Texture g_Tex;
sampler2D s = sampler_state {
	Texture = <g_Tex>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

Texture g_Map;
sampler2D DM = sampler_state {
	Texture = <g_Map>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

float Factor = 3.141592654;

float4 pSpiral ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	// transform coordinates
	texCoords -= float2(0.5, 0.5);
	float R = length(texCoords);
	float cs = cos(R * Factor);
	float sn = sin(R * Factor);
	texCoords = float2((cs * texCoords.x) + (sn * texCoords.y) + 0.5, (-sn * texCoords.x) + (cs * texCoords.y) + 0.5);

	// Don't draw if it isn't on the screen
	clip(texCoords);
	clip(1 - texCoords);

	// Return
	return tex2D(s, texCoords);
}

float4 Distort ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	float4 DP = tex2D(DM, texCoords);
	texCoords += float2(DP.x - 0.5, DP.y - 0.5) * DP.z * 0.5;
	return tex2D(s, texCoords);
}

technique Spiral
{
	pass p0
	{
		Sampler[0] = <s>;
		PixelShader = compile ps_2_0 pSpiral();
	}
}

technique Mapped
{
	pass p0
	{
		Sampler[0] = <s>;
		Sampler[1] = <DM>;
		PixelShader = compile ps_2_0 Distort();
	}
}